/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;

public class VehicleGroundDeviceBox {
    private final EntityVehicleF_Physics vehicle;
    private final boolean isFront;
    private final boolean isLeft;
    private boolean isLongTread;
    private double treadZBestOffset;
    private float climbHeight;
    private static final Set<JSONCollisionGroup.CollisionType> groundBoxCollisionTypes = new HashSet<JSONCollisionGroup.CollisionType>(Arrays.asList(JSONCollisionGroup.CollisionType.BLOCK));
    private final BoundingBox solidBox = new BoundingBox(new Point3D(), new Point3D(), 0.0, 0.0, 0.0, false, groundBoxCollisionTypes);
    private final BoundingBox liquidBox = new BoundingBox(new Point3D(), new Point3D(), 0.0, 0.0, 0.0, true, groundBoxCollisionTypes);
    private final List<BoundingBox> liquidCollisionBoxes = new ArrayList<BoundingBox>();
    private final List<PartGroundDevice> groundDevices = new ArrayList<PartGroundDevice>();
    private final List<PartGroundDevice> liquidDevices = new ArrayList<PartGroundDevice>();
    private final Point3D solidBoxNormalPos = new Point3D();
    public boolean isBlockedVertically;
    public boolean contactedEntity;
    public boolean isAirborne;
    public boolean isCollided;
    public boolean isGrounded;
    public boolean isAbleToDoGroundOperations;
    public boolean isUsingLiquidBoxes;
    public double collisionDepth;
    public final Point3D contactPoint = new Point3D();
    private static final Point3D testOffset = new Point3D();
    private static final double MAX_DELTA_FROM_ZERO = 1.0E-5;

    public VehicleGroundDeviceBox(EntityVehicleF_Physics vehicle, boolean isFront, boolean isLeft) {
        this.vehicle = vehicle;
        this.isFront = isFront;
        this.isLeft = isLeft;
    }

    public void updateMembers() {
        this.liquidCollisionBoxes.clear();
        for (BoundingBox box : this.vehicle.allCollisionBoxes) {
            boolean boxRight;
            boolean boxLeft;
            boolean boxFront;
            if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.BLOCK)) continue;
            APart partOn = this.vehicle.getPartWithBox(box);
            if (!box.collidesWithLiquids) continue;
            if (partOn != null) {
                Point3D relativePosition = partOn.position.copy().subtract(partOn.vehicleOn.position).reOrigin(partOn.vehicleOn.orientation);
                boxFront = relativePosition.z > 0.0;
                boxLeft = relativePosition.x >= -1.0E-5;
                boxRight = relativePosition.x <= 1.0E-5;
            } else {
                boxFront = box.localCenter.z > 0.0;
                boxLeft = box.localCenter.x >= 0.0;
                boolean bl = boxRight = box.localCenter.x <= 0.0;
            }
            if (this.isFront && boxFront) {
                if (this.isLeft && boxLeft) {
                    this.liquidCollisionBoxes.add(box);
                    continue;
                }
                if (this.isLeft || !boxRight) continue;
                this.liquidCollisionBoxes.add(box);
                continue;
            }
            if (this.isFront || boxFront) continue;
            if (this.isLeft && boxLeft) {
                this.liquidCollisionBoxes.add(box);
                continue;
            }
            if (this.isLeft || !boxRight) continue;
            this.liquidCollisionBoxes.add(box);
        }
        this.groundDevices.clear();
        this.liquidDevices.clear();
        float totalClimbHeight = 0.0f;
        for (APart part : this.vehicle.allParts) {
            JSONPartDefinition.JSONGroundDevicePosition groundPosition;
            if (!(part instanceof PartGroundDevice) || part.isSpare) continue;
            PartGroundDevice ground = (PartGroundDevice)part;
            APart currentPart = part;
            do {
                if ((groundPosition = currentPart.placementDefinition.groundDevicePosition) != null) continue;
                currentPart = currentPart.entityOn instanceof APart ? (APart)currentPart.entityOn : null;
            } while (groundPosition == null && currentPart != null);
            if (groundPosition == null) {
                groundPosition = ground.wheelbasePoint.z > 0.0 ? (ground.wheelbasePoint.x == 0.0 ? JSONPartDefinition.JSONGroundDevicePosition.FRONT_CENTER : (ground.wheelbasePoint.x >= 0.0 ? JSONPartDefinition.JSONGroundDevicePosition.FRONT_LEFT : JSONPartDefinition.JSONGroundDevicePosition.FRONT_RIGHT)) : (ground.wheelbasePoint.x == 0.0 ? JSONPartDefinition.JSONGroundDevicePosition.REAR_CENTER : (ground.wheelbasePoint.x >= 0.0 ? JSONPartDefinition.JSONGroundDevicePosition.REAR_LEFT : JSONPartDefinition.JSONGroundDevicePosition.REAR_RIGHT));
            }
            if (this.isFront ^ groundPosition.isFront || (!this.isLeft || !groundPosition.isLeft) && (this.isLeft || !groundPosition.isRight)) continue;
            this.groundDevices.add(ground);
            totalClimbHeight += ((JSONPart)ground.definition).ground.climbHeight;
            if (!((JSONPart)ground.definition).ground.canFloat) continue;
            this.liquidDevices.add(ground);
        }
        this.climbHeight = !this.groundDevices.isEmpty() ? totalClimbHeight / (float)this.groundDevices.size() : 0.0f;
    }

    public void updateBounds() {
        this.solidBox.localCenter.set(0.0, Double.MAX_VALUE, 0.0);
        this.solidBox.widthRadius = 0.0;
        this.solidBox.heightRadius = 0.0;
        this.isLongTread = false;
        for (APart aPart : this.groundDevices) {
            this.solidBox.localCenter.x += aPart.localOffset.x;
            this.solidBox.localCenter.z += aPart.localOffset.z;
            if (aPart.localOffset.y - aPart.getHeight() / 2.0 < this.solidBox.localCenter.y - this.solidBox.heightRadius) {
                this.solidBox.localCenter.y = aPart.localOffset.y;
                this.solidBox.heightRadius = aPart.getHeight() / 2.0;
                this.solidBox.widthRadius = aPart.getWidth() / 2.0;
            }
            if (!((JSONPart)aPart.definition).ground.isTread || ((PartGroundDevice)aPart).getLongPartOffset() == 0.0f) continue;
            this.isLongTread = true;
        }
        this.solidBox.depthRadius = this.solidBox.widthRadius;
        this.solidBox.localCenter.x *= 1.0 / (double)this.groundDevices.size();
        this.solidBox.localCenter.z *= 1.0 / (double)this.groundDevices.size();
        this.solidBoxNormalPos.set(this.solidBox.localCenter);
        this.treadZBestOffset = this.solidBoxNormalPos.z;
        this.liquidBox.localCenter.set(0.0, Double.MAX_VALUE, 0.0);
        this.liquidBox.widthRadius = 0.0;
        this.liquidBox.heightRadius = 0.0;
        for (APart aPart : this.liquidDevices) {
            this.liquidBox.localCenter.x += aPart.localOffset.x;
            this.liquidBox.localCenter.z += aPart.localOffset.z;
            if (!(aPart.localOffset.y - aPart.getHeight() / 2.0 < this.liquidBox.localCenter.y - this.liquidBox.heightRadius)) continue;
            this.liquidBox.localCenter.y = aPart.localOffset.y;
            this.liquidBox.heightRadius = aPart.getHeight() / 2.0;
            this.liquidBox.widthRadius = aPart.getWidth() / 2.0;
        }
        for (BoundingBox boundingBox : this.liquidCollisionBoxes) {
            this.liquidBox.localCenter.x += boundingBox.localCenter.x;
            this.liquidBox.localCenter.z += boundingBox.localCenter.z;
            if (!(boundingBox.localCenter.y - boundingBox.heightRadius < this.liquidBox.localCenter.y - this.liquidBox.heightRadius)) continue;
            this.liquidBox.localCenter.y = boundingBox.localCenter.y;
            this.liquidBox.heightRadius = boundingBox.heightRadius;
            this.liquidBox.widthRadius = boundingBox.widthRadius;
        }
        this.liquidBox.depthRadius = this.liquidBox.widthRadius;
        this.liquidBox.localCenter.x *= 1.0 / (double)(this.liquidDevices.size() + this.liquidCollisionBoxes.size());
        this.liquidBox.localCenter.z *= 1.0 / (double)(this.liquidDevices.size() + this.liquidCollisionBoxes.size());
    }

    public void updateCollisionStatuses(Set<PartGroundDevice> groundedGroundDevices, boolean updateGroundDeviceTreadPosition) {
        this.isBlockedVertically = false;
        this.isAirborne = true;
        this.isCollided = false;
        this.isGrounded = false;
        this.isAbleToDoGroundOperations = false;
        this.isUsingLiquidBoxes = false;
        this.collisionDepth = 0.0;
        Point3D vehicleMotionOffset = this.vehicle.motion.copy().scale(this.vehicle.speedFactor);
        if (vehicleMotionOffset.y == 0.0 && this.vehicle.towedByConnection != null && !this.vehicle.towedByConnection.hookupConnection.mounted) {
            vehicleMotionOffset.y = -1.0E-5;
        }
        Point3D groundCollisionOffset = vehicleMotionOffset.copy().add(PartGroundDevice.groundDetectionOffset);
        if (!this.groundDevices.isEmpty()) {
            if (updateGroundDeviceTreadPosition && this.isLongTread) {
                int treadSteps = this.solidBoxNormalPos.z > 0.0 ? (int)(Math.floor(this.solidBoxNormalPos.z) + 1.0) * 2 : (int)(Math.floor(-this.solidBoxNormalPos.z) + 1.0) * 2;
                double treadZCurrentOffset = this.solidBoxNormalPos.z;
                this.treadZBestOffset = this.solidBoxNormalPos.z;
                boolean foundCollidingBlock = false;
                for (int currentStep = 0; currentStep <= treadSteps; ++currentStep) {
                    this.solidBox.localCenter.set(this.solidBoxNormalPos);
                    this.solidBox.localCenter.z = treadZCurrentOffset;
                    this.contactPoint.set(this.solidBox.localCenter);
                    this.contactPoint.add(0.0, -this.solidBox.heightRadius, 0.0);
                    this.solidBox.globalCenter.set(this.solidBox.localCenter).rotate(this.vehicle.orientation).rotate(this.vehicle.rotation).add(this.vehicle.position).add(vehicleMotionOffset);
                    boolean airAtPosition = this.vehicle.world.isAir(this.solidBox.globalCenter);
                    if (airAtPosition) {
                        this.solidBox.globalCenter.y -= 1.0;
                        if (!this.vehicle.world.isAir(this.solidBox.globalCenter)) {
                            airAtPosition = false;
                        }
                        this.solidBox.globalCenter.y += 1.0;
                    }
                    if (!airAtPosition) {
                        this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, vehicleMotionOffset, false);
                        if (-this.solidBox.currentCollisionDepth.y > this.collisionDepth) {
                            foundCollidingBlock = true;
                            this.collisionDepth = -this.solidBox.currentCollisionDepth.y;
                            this.treadZBestOffset = treadZCurrentOffset;
                        }
                    }
                    treadZCurrentOffset -= this.solidBoxNormalPos.z / (double)treadSteps;
                }
                if (!foundCollidingBlock) {
                    this.solidBox.localCenter.set(this.solidBoxNormalPos);
                    this.solidBox.localCenter.z = this.treadZBestOffset;
                    this.contactPoint.set(this.solidBox.localCenter);
                    this.contactPoint.add(0.0, -this.solidBox.heightRadius, 0.0);
                    this.solidBox.globalCenter.set(this.solidBox.localCenter).rotate(this.vehicle.orientation).rotate(this.vehicle.rotation).add(this.vehicle.position).add(vehicleMotionOffset);
                    this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, vehicleMotionOffset, false);
                }
                this.contactedEntity = this.checkEntityCollisions(vehicleMotionOffset);
                boolean bl = this.isCollided = this.contactedEntity || !this.solidBox.collidingBlockPositions.isEmpty();
                if (this.contactedEntity) {
                    this.collisionDepth = -this.solidBox.currentCollisionDepth.y;
                }
            } else {
                this.solidBox.localCenter.set(this.solidBoxNormalPos);
                this.solidBox.localCenter.z = this.treadZBestOffset;
                this.contactPoint.set(this.solidBox.localCenter);
                this.contactPoint.add(0.0, -this.solidBox.heightRadius, 0.0);
                this.solidBox.globalCenter.set(this.solidBox.localCenter).rotate(this.vehicle.orientation).rotate(this.vehicle.rotation).add(this.vehicle.position).add(vehicleMotionOffset);
                this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, vehicleMotionOffset, false);
                this.contactedEntity = this.checkEntityCollisions(vehicleMotionOffset);
                this.isCollided = this.contactedEntity || !this.solidBox.collidingBlockPositions.isEmpty();
                this.collisionDepth = -this.solidBox.currentCollisionDepth.y;
            }
            if (this.isCollided) {
                this.isGrounded = true;
                this.isAirborne = false;
                this.isBlockedVertically = true;
                float offsetDelta = (float)(this.solidBox.heightRadius * 2.0);
                if (offsetDelta > 0.0f) {
                    float offset = (float)((double)this.climbHeight + this.solidBox.heightRadius) + offsetDelta;
                    do {
                        if ((offset -= offsetDelta) < offsetDelta) {
                            offset = offsetDelta;
                        }
                        VehicleGroundDeviceBox.testOffset.y = offset;
                        if (this.vehicle.world.checkForCollisions(this.solidBox, testOffset, false, false)) continue;
                        this.isBlockedVertically = false;
                        break;
                    } while (offset != offsetDelta);
                    if (this.isBlockedVertically) {
                        this.vehicle.allBlockCollisionBoxes.add(this.solidBox);
                    }
                }
            } else {
                this.solidBox.globalCenter.add(PartGroundDevice.groundDetectionOffset);
                this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, groundCollisionOffset, false);
                this.contactedEntity = this.checkEntityCollisions(groundCollisionOffset);
                this.solidBox.globalCenter.subtract(PartGroundDevice.groundDetectionOffset);
                boolean bl = this.isGrounded = this.contactedEntity || !this.solidBox.collidingBlockPositions.isEmpty();
            }
            if (this.isGrounded) {
                this.isAbleToDoGroundOperations = true;
                this.isAirborne = false;
            } else {
                groundCollisionOffset = vehicleMotionOffset.copy().add(PartGroundDevice.groundOperationOffset);
                this.solidBox.globalCenter.add(PartGroundDevice.groundOperationOffset);
                this.vehicle.world.updateBoundingBoxCollisions(this.solidBox, groundCollisionOffset, false);
                this.contactedEntity = this.checkEntityCollisions(groundCollisionOffset);
                this.solidBox.globalCenter.subtract(PartGroundDevice.groundOperationOffset);
                boolean bl = this.isAbleToDoGroundOperations = this.contactedEntity || !this.solidBox.collidingBlockPositions.isEmpty();
            }
        }
        if (!(this.isAbleToDoGroundOperations || this.liquidDevices.isEmpty() && this.liquidCollisionBoxes.isEmpty())) {
            this.liquidBox.globalCenter.set(this.liquidBox.localCenter).rotate(this.vehicle.orientation).rotate(this.vehicle.rotation).add(this.vehicle.position).add(vehicleMotionOffset);
            this.vehicle.world.updateBoundingBoxCollisions(this.liquidBox, vehicleMotionOffset, false);
            this.isCollided = !this.liquidBox.collidingBlockPositions.isEmpty();
            this.collisionDepth = -this.liquidBox.currentCollisionDepth.y;
            if (this.isCollided) {
                this.isGrounded = true;
                this.isAirborne = false;
            } else {
                this.liquidBox.globalCenter.add(PartGroundDevice.groundDetectionOffset);
                this.vehicle.world.updateBoundingBoxCollisions(this.liquidBox, groundCollisionOffset, false);
                this.liquidBox.globalCenter.subtract(PartGroundDevice.groundDetectionOffset);
                boolean bl = this.isGrounded = !this.liquidBox.collidingBlockPositions.isEmpty();
            }
            if (this.isGrounded) {
                this.isAbleToDoGroundOperations = !this.liquidDevices.isEmpty();
                this.isAirborne = false;
            } else {
                groundCollisionOffset = vehicleMotionOffset.copy().add(PartGroundDevice.groundOperationOffset);
                this.liquidBox.globalCenter.add(PartGroundDevice.groundOperationOffset);
                this.vehicle.world.updateBoundingBoxCollisions(this.liquidBox, groundCollisionOffset, false);
                this.liquidBox.globalCenter.subtract(PartGroundDevice.groundOperationOffset);
                this.isAbleToDoGroundOperations = !this.liquidDevices.isEmpty() && !this.liquidBox.collidingBlockPositions.isEmpty();
            }
            this.contactPoint.set(this.liquidBox.localCenter);
            this.contactPoint.add(0.0, -this.liquidBox.heightRadius, 0.0);
            this.isUsingLiquidBoxes = true;
        } else {
            this.isUsingLiquidBoxes = false;
        }
        if (groundedGroundDevices != null && this.isAbleToDoGroundOperations) {
            groundedGroundDevices.addAll(this.groundDevices);
        }
    }

    public boolean collidedWithTransform(TransformationMatrix transform, Point3D groundMotion) {
        Point3D vehicleMotionOffset = this.contactPoint.copy().transform(transform).subtract(this.contactPoint).rotate(this.vehicle.orientation).rotate(this.vehicle.rotation).addScaled(this.vehicle.motion, this.vehicle.speedFactor).add(groundMotion);
        if (!this.groundDevices.isEmpty() && this.vehicle.world.checkForCollisions(this.solidBox, vehicleMotionOffset, false, false)) {
            return false;
        }
        if (!this.liquidDevices.isEmpty() || !this.liquidCollisionBoxes.isEmpty()) {
            return !this.vehicle.world.checkForCollisions(this.liquidBox, vehicleMotionOffset, false, false);
        }
        return true;
    }

    private boolean checkEntityCollisions(Point3D collisionMotion) {
        boolean didCollision = false;
        for (EntityVehicleF_Physics otherVehicle : this.vehicle.world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
            if (otherVehicle.equals(this.vehicle) || !this.vehicle.canCollideWith(otherVehicle) || otherVehicle.collidedEntities.contains(this.vehicle) || !otherVehicle.encompassingBox.intersects(this.solidBox)) continue;
            BoundingBox collidingBox = null;
            for (BoundingBox box : otherVehicle.allCollisionBoxes) {
                double boxCollisionDepth;
                if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.VEHICLE) || !box.intersects(this.solidBox)) continue;
                if (collisionMotion.y > 0.0) {
                    boxCollisionDepth = this.solidBox.globalCenter.y + this.solidBox.heightRadius - (box.globalCenter.y - box.heightRadius);
                    if (!(boxCollisionDepth > this.solidBox.currentCollisionDepth.y)) continue;
                    this.solidBox.currentCollisionDepth.y = boxCollisionDepth;
                    collidingBox = box;
                    continue;
                }
                boxCollisionDepth = this.solidBox.globalCenter.y - this.solidBox.heightRadius - (box.globalCenter.y + box.heightRadius);
                if (!(boxCollisionDepth < this.solidBox.currentCollisionDepth.y)) continue;
                this.solidBox.currentCollisionDepth.y = boxCollisionDepth;
                collidingBox = box;
            }
            if (collidingBox == null) continue;
            this.vehicle.collidedEntities.add(otherVehicle);
            didCollision = true;
        }
        return didCollision;
    }

    public boolean isReady() {
        return !this.groundDevices.isEmpty() || !this.liquidCollisionBoxes.isEmpty() || !this.liquidDevices.isEmpty();
    }

    public BoundingBox getBoundingBox() {
        return this.isUsingLiquidBoxes ? this.liquidBox : this.solidBox;
    }

    public boolean isPartofBox(PartGroundDevice groundDevice) {
        return this.groundDevices.contains(groundDevice) || this.liquidDevices.contains(groundDevice);
    }

    public List<PartGroundDevice> getGroundDevices() {
        return this.groundDevices;
    }
}

